/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.buffer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jpcsp.graphics.RE.buffer.BaseBufferManager;
import jpcsp.util.Utilities;

public class BufferManagerDefault
extends BaseBufferManager {
    protected int currentBufferId;

    @Override
    protected void init() {
        super.init();
        this.currentBufferId = 12345678;
    }

    @Override
    public boolean useVBO() {
        return false;
    }

    @Override
    public int genBuffer(int target, int type, int size, int usage) {
        int totalSize = size * sizeOfType[type];
        ByteBuffer byteBuffer = this.createByteBuffer(totalSize);
        int buffer = this.currentBufferId++;
        this.buffers.put(buffer, new BaseBufferManager.BufferInfo(buffer, byteBuffer, type, size));
        return buffer;
    }

    @Override
    public void bindBuffer(int target, int buffer) {
    }

    @Override
    public void setColorPointer(int buffer, int size, int type, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        this.re.setColorPointer(size, type, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setNormalPointer(int buffer, int type, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        this.re.setNormalPointer(type, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setTexCoordPointer(int buffer, int size, int type, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        this.re.setTexCoordPointer(size, type, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setVertexAttribPointer(int buffer, int id, int size, int type, boolean normalized, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        this.re.setVertexAttribPointer(id, size, type, normalized, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setVertexPointer(int buffer, int size, int type, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        this.re.setVertexPointer(size, type, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setWeightPointer(int buffer, int size, int type, int stride, int offset) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        this.re.setWeightPointer(size, type, stride, bufferInfo.getBufferSize() - offset, bufferInfo.getBufferPosition(offset));
    }

    @Override
    public void setBufferData(int target, int buffer, int size, Buffer data, int usage) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        if (bufferInfo.byteBuffer != data) {
            bufferInfo.byteBuffer.clear();
            Utilities.putBuffer(bufferInfo.byteBuffer, data, ByteOrder.nativeOrder());
        } else {
            bufferInfo.byteBuffer.position(0);
        }
    }

    @Override
    public void setBufferSubData(int target, int buffer, int offset, int size, Buffer data, int usage) {
        BaseBufferManager.BufferInfo bufferInfo = (BaseBufferManager.BufferInfo)this.buffers.get(buffer);
        if (bufferInfo.byteBuffer != data) {
            bufferInfo.byteBuffer.clear();
            Utilities.putBuffer(bufferInfo.byteBuffer, data, ByteOrder.nativeOrder());
        } else {
            bufferInfo.byteBuffer.position(0);
        }
    }
}

